ng.$systemService.regObj = function(name, value, disabled, $filter){
	$filter = $filter || ng.$filter;
	if(!disabled){
		let obj;
		switch (name) {
		  case 'mobile':
			obj= {reg:/^1([0-9])\d{9}$/, msg:$filter('translate')('form.ERROR_PATTERN_MOBILE')};
			break;
		  case 'phone':
			obj= {reg:/^$|(0[0-9]{2,3}\-)?([2-9][0-9]{6,7})+(\-[0-9]{1,4})?$/, msg:$filter('translate')('form.ERROR_PATTERN_PHONE')};
			break;
		  case 'email':
			obj= {reg:/^[a-zA-Z0-9_+.-]+\@([a-zA-Z0-9-]+\.)+[a-zA-Z0-9]{2,10}$/, msg:$filter('translate')('form.ERROR_PATTERN_EMAIL')};
			break;
		  case 'money':
			obj= {reg:/^\d+(\.\d{1,2})?$/, msg:$filter('translate')('form.ERROR_PATTERN_MONEY')};
			break;
		  case 'moneyAllowNegative':
			obj= {reg:/^(\-|\+)?\d+(\.\d{1,2})?$/, msg:$filter('translate')('form.ERROR_PATTERN_MONEY')};
			break;
		  case 'integer':
			obj= {reg:/^\d+?$/, msg:$filter('translate')('form.ERROR_PATTERN_INTEGER')};
			break;
		  default:
			return false;
		}
		let validity =  obj.reg.test(value);
		if(value&&!validity){
		    return {
				error:true,
				msg:obj.msg
		    }
		}
	}
}