/** @gridService
 * Created by lbc on 2017/1/19 version:1.0 基于Angular原生用法封装
 * Modified By 潘正龙 2018-11-22 15:20 version2.0，基于原Angular GridService进行二次包装，变成通用组件
*/

/**全局GridService**/
var gridService = {
	/**编辑字体颜色 @param params & @returns {number}**/
    inputColor:function(params) {
        return params.data.lineEditor && params.colDef.editor;
    },
    /**是否可以编辑 @param params & @returns {*}**/
    editableFn:function(params) {
        return params.node.data.lineEditor && params.column.colDef.editor;
    },
    /**千分位数值转换**/
    formatCurrency:function(params) {
		if(params.value){
			return $filter('currency')(params.value,'￥');
		}else{
			return '';
		}
    },
    /**百分比格式化**/
    formatRate:function(params) {
		if(params.value){
			return params.value+'%';
		}else{
			return '';
		}
    },
    /**单元格货币渲染 @param params & @returns {*}**/
    currencyRenderer:function(params) {
		if (params.value === null || params.value === undefined) {
			if (params.data.lineEditor && params.colDef.editor) {
			    return '____'
			}
			return null;
		} else if (isNaN(params.value)) {
			return 'NaN';
		} else {
			if (params.node.group && params.column.aggFunc === 'count') {
			    return params.value;
			} else {
				var t = "";
				  if (params.data.lineEditor && params.colDef.editor) {
					t = '____';
				}
				if (params.data.type && params.data.type.indexOf('_rate') > 0) {
					if (isNaN(params.value) || params.value === '') {
					    return '';
					}
					return parseInt(params.value) + '%';
				}
				if (params.value == "") {
					if (!params.data.lineEditor) {
					    return '￥0';
					} else {
						if (!params.colDef.editor) {
							return '';
						}
						return '____';
					}
				}
				var filedText = params.colDef.field+"_gridType";
				if(params.data[filedText]!=undefined&&params.data[filedText]=="update"&&params.colDef.field.indexOf("_estimate")>0){
					var old='￥' + new Number(params.data[params.colDef.field+"_old"]).toFixed(2);
					if(old!="￥0.00"&&old!='￥NaN'){
					    return' <div style="margin-top:-15px"><p style="font-size: 12px!important; color:#979797; text-align:right;text-decoration: line-through' +
						'">'+old+'</p><p style="margin-top:-10px;text-align: right">'+ '￥' + new Number(params.value).toFixed(2) +'</p></div>';
					}else{
					    return $filter("currency")(params.value,"￥");
					}
				}else{
					return $filter("currency")(params.value,"￥");
				}
			}
		}
    },
    /**一行统计 @param params**/
    totalLine:function(params) {
		var obj = params.data;
		var total = 0;
		var last = 0;
		for (var p in obj) {
			if (p.indexOf("_estimate") > 5) {
				total += Number(obj[p]);
				last = Number(obj[p]);
			}
		}
		if (params.colDef.field == 'total' && obj.type.indexOf('_ytd') > 0) {
			total = last;
		}
		if (params.node.group && params.column.aggFunc === 'count') {
			return total;
		} else {
			if (params.data.type && params.data.type.indexOf('_rate') > 0) {
				if (isNaN(total)) {
					return '';
				}
				if (params.colDef.field == 'total' && obj.type == 'monthly_profit_rate') {
					var rows = params.$scope.$parent.$parent.rows;
					var monthly_profit = 0;
					var total_earning = 0;
					angular.forEach(rows, function (data) {
						if (data.type == 'monthly_profit') {
							monthly_profit = data;
						} else if (data.type == 'total_earning') {
							total_earning = data;
						}
					});
					var t = 0;
					var m = 0;
					for (var p in total_earning) {
						if (p.indexOf("_estimate") > 5) {
							t += Number(total_earning[p]);
							m += Number(monthly_profit[p]);
						}
					}
					total = m / t * 100;
					if (isNaN(total)) {
					    return '';
					}
				}
				return parseInt(total) + '%';
			}
			if (isNaN(total)) {
			    return '￥0';
			}
			return '￥' + Math.floor(total).toString().replace(/(\d)(?=(\d{3})+(?!\d))/g, "$1,");
		  }
    },
    /**货币样式 @param params & @returns {*}**/
    currencyCssFunc:function(params) {
		var obj = {};
		if (params.value !== null && params.value !== undefined && params.value < 0) {
			obj = {"color": "red", "text-align": "right", "font-weight": "bold"};
		} else {
			obj = {"text-align": "right"};
		}
		if (params.data.type != undefined && params.data.type.indexOf('total_') > -1) {
			obj.background = "rgba(255, 253, 185,0.7)";
		}
		if(params.data.operation=="update"||params.data.operation=="add"){
			obj.background = "#b7f29d";
		}
		return obj;
    },
    /**设置全局色值**/
    totalCss:function(params) {
		var obj = {};
		if(params.data.type != undefined && params.data.type.indexOf('total_') > -1) {
			obj.background = "rgba(255, 253, 185,0.7)";
		}
		if(params.data.operation=="update"||params.data.operation=="add"){
			obj.background = "#b7f29d";
		}
		return obj;
    },
    /**
     * grid统计
     * @param gridOptions
     * @param params
     * @param rows
     * @param totalNumber
     */
    gridTotal:function(gridOptions, params, rows, totalNumber) {
		if (rows == undefined) {
			rows = [];
		}
		var page = params.endRow / gridOptions.paginationPageSize;
		if(page === 1 && gridOptions.autoWidth !== undefined && !gridOptions.autoWidth){
			setTimeout(function () {
				$rootScope.loadingbar = false;
				params.successCallback(rows, totalNumber);
			},500);
		}else{
			$rootScope.loadingbar = false;
			params.successCallback(rows, totalNumber);
		}
		gridOptions.params = params;
		gridOptions.totalNumber = totalNumber;
		if (page === 1) {
			if(gridOptions.setTempListData){
			    gridOptions.setTempListData(rows);
			}
			gridOptions.loadedCount = rows.length;
			if(gridOptions.loadedCount === 0){
				if(gridOptions.showNoRowsOverlay){
					gridOptions.showNoRowsOverlay();
				}
			}else{
				if(gridOptions.hideOverlay){
					gridOptions.hideOverlay();
				}
			}
			if (gridOptions.selectedRow) {
			    gridOptions.selectedRow();
			}
			if (gridOptions.totalPosition) {
				if (gridOptions.remoteTotal) {
					gridOptions.remoteTotal(gridOptions, params, totalNumber);
				} else {
					parseTotal(gridOptions, rows);
				}
			}
		}else{
			if (gridOptions.totalPosition && totalNumber > 0) {
				if (gridOptions.remoteTotal) {
					if(page==1){
					    gridOptions.remoteTotal(gridOptions, params, totalNumber);
					}
				} else {
					parseTotal(gridOptions, rows);
			    }
			}
			gridOptions.loadedCount = (page - 1) * gridOptions.paginationPageSize + rows.length
		}
    },
    /**设置行数据并算出总和**/
    setRowDataAndTotal:function(gridOptions,rows) {
		gridOptions.setRowData(rows);
		parseTotal(gridOptions,rows);
    },
    /**显示名称**/
    displayName:function(list,value) {
		var text = value;
		for(var i=0;i<list.length;i++){
			var item=list[i];
			if(item.name==value){
				text = item.displayName;
				break;
			}
		}
		return text;
    },
    /**判断是不是文本**/
    ifText:function(param) {
		if (param.value!=undefined) {
			var text = '';
			if(param.value){
			    text = '是';
			}else{
			    text = '否';
			}
			return text;
		}
		return '';
    },
    /**判断是不是样式**/
    ifStyle:function(param) {
		if (param.value!=undefined) {
			if (param.value) {
			    return 'bg-success';
			}else{
			    return 'bg-danger';
			}
		}
		return '';
    },
    /**格式化总和**/
    parseTotal:function(gridOptions,rows) {
		var arr = [];
		angular.forEach(gridOptions.columnDefs,function (item) {
			if(item.agg){
			    arr.push({name:item.field,agg:item.agg});
			}
		});
		var obj = {
			__grid_total:true
		};
		if(gridOptions.columnDefs.length>0){
			obj[gridOptions.columnDefs[0].field]='合计：';
		  }
		angular.forEach(arr,function (item) {
			var total=0;
			angular.forEach(rows,function (data) {
				if(data[item.name] === undefined){
					data[item.name] = 0;
				}
				total+= parseFloat(data[item.name]);
			});
			obj[item.name] = total;
		});
		if(gridOptions.totalPosition === 'top'){
			gridOptions.setPinnedTopRowData([obj]);
		}else{
			gridOptions.setPinnedBottomRowData([obj]);
		}
    },

    /**
     * 远程统计
     * @param gridOptions
     * @param params
     * @param totalNumber
     * @param totalData 统计数据
     */
    remoteTotalFn:function(gridOptions,params,totalNumber,totalData) {
		var page = params.endRow / gridOptions.paginationPageSize;
		if(page==1){
			var arr=[];
			angular.forEach(gridOptions.columnDefs,function (item) {
				if(item.agg){
					arr.push({name:item.field,agg:item.agg});
				}
			});
			var obj = {
			  __grid_total:true
			};
			if(gridOptions.columnDefs.length>0){
				obj[gridOptions.columnDefs[0].field]='合计：';
			  }
			angular.forEach(arr,function (item,index) {
			    obj[item.name] = totalData[item.name];
			});
			if(gridOptions.totalPosition === 'top'){
			    gridOptions.setPinnedTopRowData([obj]);
			}else{
			    gridOptions.setPinnedBottomRowData([obj]);
			}
		}
    },
    /**日期数据初始化**/
    dateGridInit:function($scope) {
		/**取得当前日期一周内的某一天**/
		function getWeek(i) {
			var now = new Date();
			//day of week
			var n = now.getDay();
			if(n==0){
			    n=7;
			}
			var start = new Date();
			start.setDate(now.getDate() - n + i+1); /**取得一周内的第一天、第二天、第三天...**/
			return start;
		}

		/**取得当前日期一周内的七天**/
		function getWeeks() {
			var days = [];
			for(var i=1;i<=7;i++) {
			    days[i-1] = getWeek(i-1);
			}
			return days;
		}

		/**取得下一周的日期数(共七天)**/
		function getNextWeekDates(ndt) {
			var days = [];
			for(var i=1;i<=7;i++) {
			    var dt = new Date(ndt);
			    days[i-1] = getNextWeek(dt,i);
			}
			return days;
		}

		/**指定日期的下一周(后七天)**/
		function getNextWeek(dt,i) {
			var today = dt;
			today.setDate(today.getDate()+i);
			return today;
		}

		/**取得上一周的日期数(共七天)**/
		function getPreviousWeekDates(ndt) {
			var days = [];
			for(var i=-7; i<=-1; i++) {
			    var dt = new Date(ndt);
			    days[7+i] = getPreviousWeek(dt,i);
			}
			return days;
		}

		/**指定日期的上一周(前七天)**/
		function getPreviousWeek(dt,i) {
			var today = dt;
			today.setDate(today.getDate()+i);
			return today;
		}

		/**根据数值获取weekDay**/
		function getWeekDay(date) {
			var days = [];
			var fullYear = date.getFullYear();
			var month = date.getMonth();
			var day = date.getDay();
			var date0=date.getDate();
			var lastDayOfWeek= new Date(fullYear, month, date0-day);
			return getNextWeekDates(lastDayOfWeek);
		}

		/**取指定日期所在月的所有天数 @param date**/
		function getMonthDay(date) {
			var daysOfMonth = [];
			var fullYear = date.getFullYear();
			var month = date.getMonth() + 1;
			var lastDayOfMonth = new Date(fullYear, month, 0).getDate();
			for (var i = 1; i <= lastDayOfMonth; i++) {
			    daysOfMonth.push(dateParse(fullYear + '-' + month + '-' + i));
			}
			return daysOfMonth;
		}

		/**获取上个月所有日期 @param date**/
		function getPreMonthDay(date){
			var fullYear = date.getFullYear();
			var month = date.getMonth() - 1;
			return getMonthDay(new Date(fullYear,month,1))
		}

		/**获取下个月所有日期 @param date**/
		function getNextMonthDay(date){
			var fullYear = date.getFullYear();
			var month = date.getMonth() + 1;
			return getMonthDay(new Date(fullYear,month,1))
		}

		/**获取日历map**/
		function weekdayMapping(i) {
			var list=["<span style='color: #ee6b36;'>"+$filter('translate')("timeManagement.SUNDAY")+"</span>",$filter('translate')("timeManagement.MONDAY"),$filter('translate')("timeManagement.TUESDAY"),$filter('translate')("timeManagement.WEDNESDAY"),$filter('translate')("timeManagement.THURSDAY"),$filter('translate')("timeManagement.FRIDAY"),"<span style='color: #ee6b36;'>"+$filter('translate')("timeManagement.SATURDAY")+"</span>"];
			return list[i];
		}

		/**根据年份获取其他年份**/
		function getYear(year) {
			$scope.year=year;
			var arr=[];
			for(var i=1;i<=12;i++){
			    var str=year+"-"+systemService.fillZero(i,2)+"-01";
			    arr.push(dateParse(str));
			}
			return arr;
		}

		/**获取上一年**/
		function getPreYear(){
			return getYear($scope.year-1);
		}

		/**获取下一年**/
		function getNextYear(){
			return getYear($scope.year+1);
		}

		/**月份**/
		function viewMonth(month) {
			switch (month){
				case 0:
					return "一月";
				case 1:
					return "二月";
				case 2:
					return "三月";
				case 3:
					return "四月";
				case 4:
					return "五月";
				case 5:
					return "六月";
				case 6:
					return "七月";
				case 7:
					return "八月";
				case 8:
					return "九月";
				case 9:
					return "十月";
				case 10:
					return "十一月";
				case 11:
					return "十二月";
			}
		}


		/**日期类型表头样式 @param date & @return {string}**/
		$scope.getGridDateHeader = function(date) {
			var format = 'yyyy-MM-dd';
			var view = '';
			if($scope.searchObj.type === 'YEAR'){
				format = 'yyyy-MM';
				view = viewMonth(date.getMonth());
			}else{
			    view = weekdayMapping(date.getDay());
			}
			return '<span style="width:100%;display: inline-block;text-align: right;padding-right: 10px;">'+date.format(format)+'<br/>'+view+'</span>'
		};

		/**改变类型**/
		$scope.changeType = function () {
			$scope.getCurrent();
		};

		/**获取当前**/
		$scope.getCurrent = function () {
			var dates;
			if($scope.searchObj.type === 'WEEK'){
			    dates = getWeeks();
			}else if($scope.searchObj.type == 'MONTH'){
			    dates = getMonthDay(new Date());
			}else {
			    dates = getYear(new Date().getFullYear());
			}
			$scope.genHeader(dates);
		};

		/**获取上一个**/
		$scope.getPre = function () {
			var dates;
			if($scope.searchObj.type === 'WEEK'){
			    dates = dates = getPreviousWeekDates($scope.firstDay);
			}else if($scope.searchObj.type=='MONTH'){
			    dates = dates = getPreMonthDay($scope.firstDay);
			}else {
			    dates = getPreYear();
			}
			$scope.genHeader(dates);
		};

		/**获取下一个**/
		$scope.getNext = function () {
			var dates;
			if($scope.searchObj.type === 'WEEK'){
			    dates = dates = getNextWeekDates($scope.lastDay);
			}else if($scope.searchObj.type === 'MONTH'){
			    dates = dates = getNextMonthDay($scope.lastDay);
			}else {
			    dates = getNextYear();
			}
			$scope.genHeader(dates);
		};
    }
};

/**全局ObjectEditor**/
function ObjectEditor() {};
ObjectEditor.prototype.init = function (params) {
  this.eInput = document.createElement('input');
  this.eInput.className = 'ag-cell-edit-input';
  this.eInput.value = params.value;
  this.eInput.setAttribute('ng-model', 'data.' + params.column.colId);
  this.focusAfterAttached = true;
};
ObjectEditor.prototype.afterGuiAttached = function () {
  if (!this.focusAfterAttached) {
    return;
  }
  var eInput = this.getGui();
  eInput.focus();
  if (this.highlightAllOnFocus) {
    eInput.select();
  }
  else {
    var length = eInput.value ? eInput.value.length : 0;
    if (length > 0) {
      eInput.setSelectionRange(length, length);
    }
  }
};
// gets called when tabbing trough cells and in full row edit mode
ObjectEditor.prototype.focusIn = function () {
  var eInput = this.getGui();
  eInput.focus();
  eInput.select();
};
ObjectEditor.prototype.getValue = function () {
  var eInput = this.getGui();
  return eInput.value;
};
ObjectEditor.prototype.getGui = function () {
  return this.eInput;
};