/**
** Created By 潘正龙 version1.0 Time:2018-08-31 创建原生JS方法
** Modified By 潘正龙 version1.1 Time:2018-09-18 修改为兼容Angular的原生方法
** Modified By 潘正龙 version1.2 Time:2018-09-19 修改为通用类别的原生方法
** Modified By 潘正龙 version1.3 Time:2018-10-17 修改from和steplist在修改状态下的ajax数据提交方法(同步，其他都是异步)
**/

var collectGuestBehavior = {
  from:{},
  stepLists:[],
	// 获取Route-Start参数
	startRoute:function(systemService, toState, toParams, fromState, fromParams){
		if(!sessionStorage.from && !sessionStorage.stepLists){ // 未设置collect参数
			var from = collectGuestBehavior.buildFrom(systemService, collectGuestBehavior.from), stepLists = collectGuestBehavior.stepLists;
			var SEList = [
				{test:'baidu.com',name:'百度搜索引擎',type:1},
				{test:'so.com',name:'360搜索引擎',type:1},
				{test:'sogou.com',name:'搜狗搜索引擎',type:1},
				{test:'bing.com',name:'必应搜索引擎',type:1},
				{test:'google.com',name:'谷歌搜索引擎',type:1},
				{test:'qq.com',name:'QQ搜索引擎',type:1},
				{test:'360.cn',name:'360搜索引擎',type:1},
				{test:'sohu.com',name:'搜狐搜索引擎',type:1},
				{test:'sina.com.cn',name:'新浪搜索引擎',type:1},
				{test:'2345.com',name:'2345搜索引擎',type:1},
				{test:'hao123.com',name:'hao123搜索引擎',type:1},
				{test:'soso.com',name:'搜搜搜索引擎',type:1},
				{test:'haoso.com',name:'好搜搜索引擎',type:1},
				{test:'easou.com',name:'宜搜搜索引擎',type:1},
				{test:'roboo.com',name:'儒豹搜索引擎',type:1},
				{test:'sm.cn',name:'神马搜索引擎',type:1},
				{test:'chinaso.com',name:'中国搜索引擎',type:1},
				{test:'yicha.cn',name:'易查搜索引擎',type:1},
				{test:'youdao.com',name:'网易有道搜索引擎',type:1},
				{test:'zhongsou.cn',name:'中搜搜索引擎',type:1}
			];
			$.ajax({ // 获取服务端Request Headers信息，定义From来源
				url: window.location.href,
				type: "GET",
				async:false,
				error:function(){},
				success:function(data,textStatus,res){
					if(!!res.getResponseHeader("Referer")){ // 从其他网站跳转过来
						from.fromUrl = res.getResponseHeader("Referer");
						from.fromTitle = '站外链接';
						from.fromType = 2;
						for(var i=0;i<SEList.length;i++){
							if(from.fromUrl.indexOf(SEList[i].test) > -1){
								from.fromType = SEList[i].type;
								from.fromTitle = SEList[i].name
							}
						}
					}else{ // 从本地跳转或者无结果
						from.fromType = 3;
						if(toState.name == 'page.login'){
							from.fromUrl = fromState.name;
							from.fromTitle = '系统登录';
						}else{
							from.fromUrl = window.location.href.split('&newDate')[0].split('&_')[0];
							from.fromTitle = toState.title;
						}
					}
				}
			});
			var first = {};
			first = collectGuestBehavior.buildStep(first, toState, toParams, fromState, fromParams, from);
			stepLists.push(first);
			sessionStorage.stepLists = JSON.stringify(stepLists);
			sessionStorage.from = JSON.stringify(from);
		}else if(!!sessionStorage.from && !!sessionStorage.stepLists){ // 已设置collect参数
			var from = JSON.parse(sessionStorage.from), stepLists = JSON.parse(sessionStorage.stepLists);
			var previous = stepLists[stepLists.length - 1],next = {};
			previous.pageUrl = window.location.href.split('&newDate')[0].split('&_')[0];
			previous.endTime = new Date().valueOf();
			previous.stepTime = previous.endTime - previous.startTime;
			next = collectGuestBehavior.buildStep(next, toState, toParams, fromState, fromParams, from, previous);
			stepLists.push(next);
			sessionStorage.stepLists = JSON.stringify(stepLists);
		}
	},

	// 获取Route-Success参数
	successRoute:function(systemService, toState, toParams, fromState, fromParams){
		if(!!sessionStorage.from && !!sessionStorage.stepLists){ // 修改参数，定义steps
			var from = JSON.parse(sessionStorage.from), stepLists=JSON.parse(sessionStorage.stepLists);
			from.endTime = new Date().valueOf();
			var current = stepLists[stepLists.length - 1]; // 当前数据
			current.loadTime = from.endTime - current.startTime;
			if(!from.fromUrl){
			  from.fromUrl = window.location.href.split('&newDate')[0].split('&_')[0];
			  from.fromTitle = current.title
			}
			if(!from.userId){ // 用户信息不存在
        if(!!systemService.getUserSession()){ // 用户首次登录
          //console.log('用户首次登录，提交数据')
          var UserInfo = systemService.getUserSession();
          from.userId = UserInfo.id;
          from.userType = UserInfo.ownerId;
          collectGuestBehavior.submit('from',from,'add', true); // 创建新的from提交
          var visitKey = JSON.parse(sessionStorage.from).visitKey, NewStepLists = [];
          for(var i=0;i<stepLists.length;i++){
            stepLists[i].visitKey = visitKey;
            if(!!stepLists[i].pageUrl){
              collectGuestBehavior.submit('step',stepLists[i],'add', true);
            }else{
              NewStepLists.push(stepLists[i])
            }
          }
          sessionStorage.stepLists = JSON.stringify(NewStepLists);
          return false;
        }else{ // 用户未登录
          //console.log('用户未登录，不提交数据')
          return false;
        }
			}else{ // 用户信息已存在
        if(toState.name == 'page.login'){ // 退出登录
          if(stepLists.length > 2){ //
            stepLists.splice(0,1)
          }
          collectGuestBehavior.submit('from',from,'edit', true); // 提交修改后的from
          for(var i=0;i<stepLists.length;i++){
            if(!!stepLists[i].pageUrl){
              stepLists[i].pageUrl = window.location.href.split('&newDate')[0].split('&_')[0];
              stepLists[i].endTime = new Date().valueOf();
              stepLists[i].loadTime = from.endTime - stepLists[i].startTime;
              stepLists[i].stepTime = stepLists[i].endTime - stepLists[i].startTime;
            }
            collectGuestBehavior.submit('step',stepLists[i],'add', true); // List提交
          }
          //sessionStorage.tempFrom = sessionStorage.from;
          sessionStorage.removeItem('stepLists'); // 清除list
          sessionStorage.removeItem('from'); // 清除from
        }else{ // 正常访问
          if(!from.visitKey){ // 未获取到key
            return false;
          }
          if(stepLists.length > 2){ // 第一次点击以后提交stepList[0]
            stepLists.splice(0,1)
          }else if(stepLists.length == 1){
            console.log('检查成功不提交');
            return false
          }
          collectGuestBehavior.submit('step',stepLists[0],'add', true); // 创建新的step提交
          sessionStorage.stepLists = JSON.stringify(stepLists);
        }
      }
		}
	},

	//用户采集数据提交
	submit:function(collectType, obj, type, RequestAsync) {
		var NewObj = JSON.parse(JSON.stringify(obj)), URL = pgyBase.HostUrl, AjaxType;
		if(collectType == 'step'){
			for(var i in NewObj){
			  if(i == 'startTime' || i == 'endTime'){
				NewObj[i] = NewObj[i] + parseFloat(localStorage.TimeDvalue)
			  }
			}
			URL += 'behavioralDataDetails';
			AjaxType = 'POST';
			console.log('新增list');
		}else if(collectType == 'from'){
			URL += 'behavioralDatas';
			if(type == 'add'){
			  for(var i in NewObj){
				if(i == 'startTime' || i == 'endTime'){
				  NewObj[i] = NewObj[i] + parseFloat(localStorage.TimeDvalue)
				}
			  }
			  AjaxType = 'POST';
			  console.log('新增from');
			}else if(type == 'edit'){
			  for(var i in NewObj){
				if(i == 'endTime'){
				  NewObj[i] = NewObj[i] + parseFloat(localStorage.TimeDvalue)
				}
			  }
			  AjaxType = 'PUT';
			  console.log('修改from');
			}
		}
		pgyBase.Ajax(RequestAsync, AjaxType, URL, do_result, NewObj);
		function do_result(res) {
			if(collectType == 'from' && res.status == 'SUCCESS' && type == 'add'){
				sessionStorage.from = JSON.stringify(res.content);
			}
		}
	},

	// 获取From参数
	buildFrom:function (systemService, obj) {
		obj = {
			ipAddress:'', // 用户IP信息
			equipment:'', // 设备
			equipmentOS:'', // 设备系统
			osVersion:'', // 系统版本
			browser:'', // 浏览器
			browserVersion:'', // 浏览器版本
			startTime: new Date().valueOf(), // 定义开始时间
			endTime: '', // 定义结束时间
			visitKey: '', // 获取用户的UID
			fromType:null, // 访问来源类型
			fromUrl:'', // 访问来源url
			fromTitle:'', // 访问的备注说明
			userType:null, // 用户类型
			userId:null // 用户主键id
		};
		var UA = navigator.userAgent.toLocaleLowerCase();
		// 第一步先判断设备类型，OS类型，OS版本
		if(UA.indexOf("macintosh") > -1){ // 判断苹果电脑
			obj.equipment = 'Macintosh';
			obj.equipmentOS = 'Mac OS X';
			var t = UA.indexOf('mac os x'), t1 = UA.indexOf(')');
            obj.osVersion = UA.slice(t+9,t1).replace('mac os x','').replace(/_/g, '.');
			/*
			var PcList = UA.split(';');
			for(var i=0;i<PcList.length;i++){
				if(PcList[i].indexOf('mac os x')){
					obj.osVersion = PcList[i].slice(PcList[i].indexOf('mac os x'),PcList[i].length).replace('mac os x','').replace(/_/g, '.')
				}
			}*/
			if(obj.osVersion == ''){
				obj.osVersion = 'Mac OS X'
			}
		}else if(UA.indexOf("windows") > -1){ // 判断windows电脑
			obj.equipment = 'Windows';
			var PcList = [
				{name:'5.0',OS:'2000',version:'2000'},
				{name:'5.1',OS:'XP',version:'Sp1 / Sp2'},
				{name:'5.2',OS:'XP / 2003',version:'XP Sp3 / Server 2003'},
				{name:'6.0',OS:'Vista / 2008',version:'Vista / Server 2008'},
				{name:'6.1',OS:'7 / 2008',version:'7 / Server 2008 R2'},
				{name:'6.2',OS:'8 / 2012',version:'8 / Server 2012'},
				{name:'6.3',OS:'8.1 / 2012',version:'8.1 / Server 2012 R2'},
				{name:'6.4',OS:'10',version:'6.4'},
				{name:'10.0',OS:'10',version:'10.0'}
			];
			for(var i=0;i<PcList.length;i++){
				var win = 'windows nt '+ PcList[i].name;
				if(UA.indexOf(win) > -1){
					obj.equipmentOS = 'Windows '+PcList[i].OS;
					obj.osVersion = 'Win'+PcList[i].version
				}
			}
		}else if(UA.indexOf("android") > -1 || UA.indexOf("linux") > -1){ // 安卓设备
			obj.equipment = 'Android';
			var MList = UA.split(';');
			for(var i=0;i<MList.length;i++){
				if(MList[i].indexOf('android')){
					obj.equipmentOS = 'Android'+ MList[i].slice(MList[i].indexOf('android'),MList[i].length).replace('android','').replace(/\*|\_|\?/g,".").replace(/\-|\+|\?/g," ")
				}
				if(MList[i].indexOf('build')){
					obj.osVersion = MList[i].slice(0,MList[i].indexOf('build')).replace(/\*|\_|\?/g,".").replace(/\-|\/|\+|\?/g," ")
				}
			}
		}else if(!!UA.match(/\(i[^;]+;( U;)? cpu.+mac os x/)){ // IOS设备
			obj.equipment = 'IOS';
			if(UA.indexOf('iphone') > -1){
				obj.equipmentOS = 'Iphone'
			}else if(UA.indexOf('ipad') > -1){
				obj.equipmentOS = 'Ipad'
			}else if(UA.indexOf('ipod') > -1){
				obj.equipmentOS = 'Ipod'
			}
			obj.osVersion = UA.slice(UA.lastIndexOf(obj.equipmentOS),UA.indexOf('like')-1).replace(obj.equipmentOS+' os','').replace(/\*|\_|\?/g,".").replace(/\-|\/|\+|\?/g," ")
		}
		// 第二步通用获取浏览类的类型和版本
		var UAList = UA.split(' ');
		var TestList = [
			{test:'tencenttraveler',name:'TencentTraveler',get:'tencenttraveler'},
			{test:'firefox',name:'FireFox',get:'firefox'},
			{test:'micromessenger',name:'WeXin',get:'micromessenger'},
			{test:'edge',name:'Edge',get:'edge'},
			{test:'bidubrowser',name:'BaiDuBrowser',get:'bidubrowser'},
			{test:'maxthon',name:'Maxthon',get:'maxthon'},
			{test:'qqbrowser',name:'QQBrowser',get:'qqbrowser'},
			{test:'opera',name:'Opera',get:'opera'},
			{test:'opr',name:'Opera',get:'opr'},
			{test:'presto',name:'Opera',get:'version'},
			{test:'360se',name:'360SE',get:'360se'},
			{test:'360ee',name:'360EE',get:'360ee'},
			{test:'metasr',name:'SoGou',get:'metasr'},
			{test:'se',name:'SoGou',get:'se'},
			{test:'the world',name:'The World',get:'the world'},
			{test:'theworld',name:'The World',get:'theworld'},
			{test:'uc',name:'UC',get:'uc'},
			{test:'ubrowser',name:'UC',get:'ubrowser'},
			{test:'lbbrowser',name:'LBBrowser',get:'lbbrowser'},
			{test:'version',name:'Safari',get:'version'},
			{test:'chrome',name:'Chrome',get:'chrome'},
			{test:'iemobile',name:'IEMobile',get:'iemobile'},
			{test:'trident/7.0',name:'MSIE',get:'rv:'},
			{test:'msie',name:'MSIE',get:'msie'}
		];
		/****先判断webkit核心****/
		if(UA.indexOf('khtml') > -1 && UA.indexOf('gecko') > -1 && UA.indexOf('safari') > -1 && UA.indexOf('applewebkit') > -1){
			for(var i=0;i<TestList.length;i++) {
				if (UA.indexOf(TestList[i].test) > -1) {
					obj.browser = TestList[i].name;
					getBrowserVersion(TestList[i].get);
					break;
				}
			}
		}else{ /**判断非webkit核心浏览器**/
			for(var i=0;i<TestList.length;i++){
				if(UA.indexOf(TestList[i].test) > -1){
					obj.browser = TestList[i].name;
					getBrowserVersion(TestList[i].get);
					break;
				}
			}
		}
		  /**IE内核加以判断**/
		if(UA.indexOf("trident") > -1 || UA.indexOf("msie") > -1){ // IE内核加以判断
			if(UA.indexOf("msie") > -1){
				getBrowserVersion('msie')
			}else if(UA.indexOf("trident") > -1){
				getBrowserVersion('rv')
			}
			obj.browserVersion = 'IE'+ obj.browserVersion;
		}
		/**浏览器版本获取方法**/
		function getBrowserVersion(browser) {
			for(var i=0;i<UAList.length;i++){
				if(UAList[i].indexOf(browser) > -1){
					UAList[i] = UAList[i].replace(/\;|\:|\)|\*|\_|\-|\/|\+|\?/g,'');
					obj.browserVersion = UAList[i].slice(UAList[i].indexOf(browser)+browser.length,UA.length);
					break;
				}
			}
		}
		return obj;
	},

	// 创建采集对象
	buildStep:function(obj, toState, toParams, fromState, fromParams, from, previous){
		obj = {
			controller:toState.controller,
			pageUrl:'',
			pageTitle:toState.title,
			pageRoute:toState.name,
			name:toState.url,
			params:'',
			startTime:'' || 0, // 开始时间
			endTime:'' || 0, // 结束时间
			loadTime:'' || 0, // 加载时间
			stepTime:'' || 0, // 停留时间
			visitKey:from.visitKey // 用户的UID
		};
		if(!!previous){
			obj.startTime = previous.endTime
		}else{
			obj.startTime = from.startTime
		}
		if(!!toParams){
			obj.params = JSON.parse(JSON.stringify(toParams));
			if(!!obj.params.newDate){
				delete obj.params.newDate
			}
			if(!!obj.params._){
				delete obj.params._
			}
			obj.params = JSON.stringify(obj.params)
		}else{
			obj.params = '采集菜单,功能切换'
		}
		return obj;
	}
};

// 监控窗口刷新和窗口的关闭状态
$(window).bind('beforeunload', function(){
	var from = JSON.parse(sessionStorage.from), stepLists=JSON.parse(sessionStorage.stepLists);
	var goFresh = stepLists[stepLists.length - 1];
	goFresh.pageUrl = window.location.href.split('&newDate')[0].split('&_')[0];
	goFresh.endTime = new Date().valueOf();
	goFresh.stepTime = goFresh.endTime - goFresh.startTime;
	from.endTime = goFresh.endTime;
	collectGuestBehavior.submit('from',from,'edit', false); // 提交修改后的from
	collectGuestBehavior.submit('step',goFresh,'add', false); // 提交新的step
	if(stepLists.length == 2){
		stepLists.splice(0,1)
	}
	sessionStorage.stepLists = JSON.stringify(stepLists);
	sessionStorage.from = JSON.stringify(from);
	return '您可能有数据没有保存';
});
window.onbeforeunload = function() {
	var n = window.event.screenX - window.screenLeft;
	var b = n > document.documentElement.scrollWidth-20;
	if(b && window.event.clientY < 0 || window.event.altKey) {
		console.log("是关闭而非刷新");
	}else{
		console.log("是刷新而非关闭");
	}
};
